/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	NewPart.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

// Create New Part and return the newly created Part.
HRESULT NewPart(IPartDocument **retval)
{
	START_METHOD("NewPart")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *pDisp = NULL;
	status = pdApplication->NewPart(&pDisp);
	CHECK_RETURN_STATUS(status)

	*retval = pDisp;

	END_METHOD("NewPart")
}
